//+------------------------------------------------------------------+
#property copyright "Daniel Jose"
//+------------------------------------------------------------------+
#property description "DEMO Indicator"
//+------------------------------------------------------------------+
const struct stAverange
{
   uint           nPeriods;
   ENUM_MA_METHOD Method;
   color          cor;
}Averange[] = 
{
   // {9, MODE_EMA, clrRed},
   {20, MODE_SMA, clrGreen},
   // {50, MODE_SMA, clrBlue},
   // {200, MODE_SMA, clrBlack}
};
//+----------------+
#property indicator_chart_window
#property indicator_applied_price   PRICE_CLOSE
#property indicator_buffers         Averange.Size();
#property indicator_plots           Averange.Size();
//+------------------------------------------------------------------+
struct stInfos
{
   double   Buff_iMA[];
   int      Handle;
}Infos[Averange.Size()];
//+------------------------------------------------------------------+
int OnInit(void)
{
   for (uint c = 0; c < Averange.Size(); c++)
   {
      SetIndexBuffer(c, Infos[c].Buff_iMA, INDICATOR_DATA);
      PlotIndexSetInteger(c, PLOT_DRAW_TYPE, DRAW_LINE);
      PlotIndexSetInteger(c, PLOT_LINE_STYLE, STYLE_SOLID);
      PlotIndexSetInteger(c, PLOT_LINE_WIDTH, 2);
      PlotIndexSetInteger(c, PLOT_LINE_COLOR, Averange[c].cor);
      PlotIndexSetString(c, PLOT_LABEL, StringFormat("%s of %d", (Averange[c].Method == MODE_EMA ? "Exponential" : "Arithmetica"), Averange[c].nPeriods));
      if ((Infos[c].Handle = iMA(NULL, NULL, Averange[c].nPeriods, 0, Averange[c].Method, _AppliedTo)) == INVALID_HANDLE)
      {
         Print("Could not start the indicator...");
         return INIT_FAILED;
      };
   }

   return INIT_SUCCEEDED;
};
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total, const int prev_calculated, const int begin, const double &price[])
{
   for (uint c = 0; c < Averange.Size(); c++)
   {
  	   ArrayInitialize(Infos[c].Buff_iMA, EMPTY_VALUE);
      CopyBuffer(Infos[c].Handle, 0, 0, Bars(NULL, NULL), Infos[c].Buff_iMA);
   }

   return rates_total;
};
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
{
   for (uint c = 0; c < Averange.Size(); c++)
      IndicatorRelease(Infos[c].Handle);
};
//+------------------------------------------------------------------+